local super = require "ButtonBarElement"

ButtonBarFramelessElement = super:new()

ButtonBarFramelessElement.defaultFont = Font.system(12)

function ButtonBarFramelessElement:getSpacing()
    return 3
end

function ButtonBarFramelessElement:draw(canvas)
    local height = self.height
    local width = self.width
    local rect = Rect:new{left = 0, bottom = 1 + self:getSpacing(), right = width, top = height - self:getSpacing()}
    local fillPath = Path.rect(rect, 4)
    
    canvas:setPaint(self:backgroundPaint(rect))
        :fill(fillPath)
    
    local icon = self.icon
    if icon then
        local iconWidth = self.iconWidth
        local iconInset = self.iconInset
        local iconRect = Rect:new{left = iconInset, bottom = 1 + iconInset, right = iconInset + iconWidth, top = height - iconInset}
        canvas:preserve(function(canvas)
            canvas:clipIcon(icon, iconRect)
                :setPaint(self:iconPaint())
                :fill(fillPath)
        end)
    end
    
    local styledString = self.truncatedString
    if styledString then
        local textWidth = self.textWidth
        local textInset = self.textInset
        local textRect = styledString:measure()
        local x = width - textInset - 0.5 * textWidth - textRect:minx()
        local y = 1 + math.ceil(0.5 * (height - textRect:height()) - textRect:miny())
        canvas:setPaint(self:textPaint())
            :drawText(styledString, x, y, 0.5)
    end
end

function ButtonBarFramelessElement:backgroundPaint(rect)
    if self.state then
        return Color.highlight(0.25)
    elseif self.pressing then
        return Color.gray(0, 0.06)
    else
        return Color.invisible
    end
end

function ButtonBarFramelessElement:textPaint()
    if self.state then
        return Color.tint(1)
    else
        return Color.gray(0, 0.75)
    end
end

function ButtonBarFramelessElement:iconPaint()
    if self.state then
        return Color.tint(0.8)
    else
        return Color.gray(0, 0.6)
    end
end

function ButtonBarFramelessElement:strokePaint()
    return Color.invisible
end

return ButtonBarFramelessElement
